/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.internal.DefaultShellCallback;

public class MyBatisVelocityEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(MyBatisVelocityEngine.class);
    private static final String BASEDIR = "baseDir";
    private static final String DATADIR = "dataDir";
    private static final String CONFIGTEMPLATE = "configTemplate";
    private static final String JAVADIR = "javaDir";
    private static final String PACKAGE = "packAge";
    private static final String DRIVERJAR = "driverJar";
    private static final String DRIVERCLASS = "driverClass";
    private static final String CONNECTIONURL = "connectionURL";
    private static final String USERID = "userId";
    private static final String PASSWORD = "password";
    private static final String SCHEMA = "schema";
    private static String dbTransferTemplate = "";
    private static String dbTransferDir = "";

    public static void main(String[] args) throws Exception {
        List<CodeInfo> list = MyBatisVelocityEngine.findDesigner(MyBatisVelocityEngine.getDir(DATADIR));
        for (int i = 0; i < list.size(); ++i) {
            CodeInfo info = list.get(i);
            MyBatisVelocityEngine.configGenerator(info);
            for (int j = 0; j < info.getList().size(); ++j) {
                Map<String, String> map = info.getList().get(j);
                map.put("code", info.getCode());
                map.put("name", info.getName());
                MyBatisVelocityEngine.dbTransferGenerator(map);
            }
        }
    }

    public static void configGenerator(CodeInfo codeinfo) {
        String baseDir = MyBatisVelocityEngine.getDir(BASEDIR);
        String dataDir = MyBatisVelocityEngine.getDir(DATADIR);
        String configTemplate = MyBatisVelocityEngine.getSysProperty(CONFIGTEMPLATE);
        String javaDir = MyBatisVelocityEngine.getSysProperty(JAVADIR);
        String packAge = MyBatisVelocityEngine.getSysProperty(PACKAGE);
        String driverJar = MyBatisVelocityEngine.getSysProperty(DRIVERJAR);
        String driverClass = MyBatisVelocityEngine.getSysProperty(DRIVERCLASS);
        String connectionURL = MyBatisVelocityEngine.getSysProperty(CONNECTIONURL);
        String userId = MyBatisVelocityEngine.getSysProperty(USERID);
        String password = MyBatisVelocityEngine.getSysProperty(PASSWORD);
        String schema = MyBatisVelocityEngine.getSysProperty(SCHEMA);
        dbTransferDir = MyBatisVelocityEngine.getSysProperty("dbTransferDir");
        dbTransferTemplate = MyBatisVelocityEngine.getSysProperty("dbTransferTemplate");
        File file = new File(configTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + configTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            File fileDir = new File(javaDir);
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            Map<?, ?> map = MyBatisVelocityEngine.obj2Map(codeinfo);
            map.put(BASEDIR, baseDir);
            map.put(DATADIR, dataDir);
            map.put(JAVADIR, javaDir);
            map.put(PACKAGE, packAge);
            map.put(DRIVERJAR, driverJar);
            map.put(DRIVERCLASS, driverClass);
            map.put(CONNECTIONURL, connectionURL);
            map.put(USERID, userId);
            map.put(PASSWORD, password);
            map.put(SCHEMA, schema);
            map.put("dbTransferDir", dbTransferDir);
            map.put("dbTransferTemplate", dbTransferTemplate);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String configFile = baseDir + "generatorConfig.xml";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, configTemplate), configFile);
                MyBatisVelocityEngine.beanGenerator(configFile);
            }
            catch (Exception var19) {
                logger.error((Object)"\u751f\u6210\u5b9e\u4f53Bean\u9519\u8bef:", (Throwable)var19);
            }
        }
    }

    public static void beanGenerator(String configxml) {
        try {
            ArrayList warnings = new ArrayList();
            boolean overwrite = true;
            File configFile = new File(configxml);
            ConfigurationParser cp = new ConfigurationParser(warnings);
            for (String warning : warnings) {
                logger.warn((Object)warning);
            }
            Configuration config = cp.parseConfiguration(configFile);
            DefaultShellCallback callback = new DefaultShellCallback(overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate(null);
            for (String warning : warnings) {
                logger.warn((Object)warning);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
    }

    public static void dbTransferGenerator(Map<String, String> map) {
        if (dbTransferTemplate == null) {
            logger.error((Object)("[ " + dbTransferTemplate + " ] \u4e0d\u5b58\u5728!"));
            return;
        }
        File file = new File(dbTransferTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + dbTransferTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u6570\u636e\u5e93\u8f6c\u5316\u6570\u636e:" + map));
            String classNmae = MyBatisVelocityEngine.underline2Camel(map.get("\u8868/\u8bd5\u56fe\u540d\u79f0"));
            map.put("className", classNmae);
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String transferFile = dbTransferDir + "com/miniframe/dbtransfer/" + classNmae + "DbTransfer.java";
                File file1 = new File(transferFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, dbTransferTemplate), transferFile);
                }
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210\u6570\u636e\u5e93\u8f6c\u5316\u6587\u4ef6\u9519\u8bef:", (Throwable)var5);
            }
        }
    }

    private static String camel2Underline(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toLowerCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase()) && !Character.isDigit(s.charAt(0))) {
                    result.append("_");
                }
                result.append(s.toLowerCase());
            }
        }
        return result.toString();
    }

    private static String underline2Camel(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        boolean isUpper = false;
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toUpperCase());
            for (int i = 1; i < name.length(); ++i) {
                boolean isAppend = true;
                String s = name.substring(i, i + 1);
                if (s.equals("_")) {
                    isUpper = true;
                    isAppend = false;
                }
                if (!isAppend) continue;
                if (isUpper) {
                    result.append(s.toUpperCase());
                } else {
                    result.append(s.toLowerCase());
                }
                isUpper = false;
            }
        }
        return result.toString();
    }
}

