/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.util;

import com.miniframe.designer.util.ClassAnalysis;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import net.sf.cglib.beans.BulkBean;

public class ObjAnalysis {
    private Map map = new LinkedHashMap();
    private String propName = "";
    private Stack stack = new Stack();

    public ObjAnalysis(Object obj, Class clazz) {
        ClassAnalysis classAnalysis = new ClassAnalysis(clazz);
        this.convertObjToMap(obj, classAnalysis);
    }

    private String getPropName(Stack stack) {
        String propName = "";
        Iterator itr = stack.iterator();
        int i = 0;
        while (itr.hasNext()) {
            propName = i == 0 ? itr.next().toString() : propName + "." + itr.next().toString();
            ++i;
        }
        return propName;
    }

    public Map getObjPropertyMap() {
        return this.map;
    }

    private void convertObjToMap(Object obj, ClassAnalysis classAnalysis) {
        String[] propertyNames = classAnalysis.getPropertyNames();
        String[] getters = classAnalysis.getGetterNames();
        String[] setters = classAnalysis.getSetterNames();
        Class[] types = classAnalysis.getPropTypes();
        BulkBean bulkbean = BulkBean.create((Class)classAnalysis.getAnalysisClass(), (String[])getters, (String[])setters, (Class[])types);
        Object[] objPropertyValues = bulkbean.getPropertyValues(obj);
        for (int i = 0; i < propertyNames.length; ++i) {
            this.stack.push(propertyNames[i]);
            this.propName = this.getPropName(this.stack);
            this.map.put(this.propName, objPropertyValues[i]);
            if (objPropertyValues[i] != null) {
                ClassAnalysis clazzAnaly2 = new ClassAnalysis(objPropertyValues[i].getClass());
                if (clazzAnaly2.getPropertyNames() != null && clazzAnaly2.getPropertyNames().length > 0) {
                    this.convertObjToMap(objPropertyValues[i], clazzAnaly2);
                }
            } else {
                this.map.put(this.propName, null);
            }
            this.stack.pop();
        }
    }
}

