/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.expression.EqExpression;
import net.sf.hibernate.expression.LikeExpression;
import net.sf.hibernate.expression.MatchMode;
import net.sf.hibernate.expression.NullExpression;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class Example
extends AbstractCriterion {
    private final Object entity;
    private final Set excludedProperties = new HashSet();
    private PropertySelector selector;
    private boolean isLikeEnabled;
    private boolean isIgnoreCaseEnabled;
    private MatchMode matchMode;
    private static final PropertySelector NOT_NULL = new NotNullPropertySelector();
    private static final PropertySelector ALL = new AllPropertySelector();
    private static final PropertySelector NOT_NULL_OR_ZERO = new NotNullOrZeroPropertySelector();
    private static final Object[] TYPED_VALUES = new TypedValue[0];

    public Example setPropertySelector(PropertySelector selector) {
        this.selector = selector;
        return this;
    }

    public Example excludeZeroes() {
        this.setPropertySelector(NOT_NULL_OR_ZERO);
        return this;
    }

    public Example excludeNone() {
        this.setPropertySelector(ALL);
        return this;
    }

    public Example enableLike(MatchMode matchMode) {
        this.isLikeEnabled = true;
        this.matchMode = matchMode;
        return this;
    }

    public Example enableLike() {
        return this.enableLike(MatchMode.EXACT);
    }

    public Example ignoreCase() {
        this.isIgnoreCaseEnabled = true;
        return this;
    }

    public Example excludeProperty(String name) {
        this.excludedProperties.add(name);
        return this;
    }

    public static Example create(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null example");
        }
        return new Example(entity, NOT_NULL);
    }

    protected Example(Object entity, PropertySelector selector) {
        this.entity = entity;
        this.selector = selector;
    }

    public String toString() {
        return this.entity.toString();
    }

    private boolean isPropertyIncluded(Object value, String name, Type type) {
        return !this.excludedProperties.contains(name) && !type.isAssociationType() && this.selector.include(value, name, type);
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        StringBuffer buf = new StringBuffer().append("(");
        ClassMetadata meta = sessionFactory.getClassMetadata(persistentClass);
        String[] propertyNames = meta.getPropertyNames();
        Type[] propertyTypes = meta.getPropertyTypes();
        Object[] propertyValues = meta.getPropertyValues(this.entity);
        for (int i = 0; i < propertyNames.length; ++i) {
            boolean isPropertyIncluded;
            Object propertyValue = propertyValues[i];
            String propertyName = propertyNames[i];
            boolean bl = isPropertyIncluded = i != meta.getVersionProperty() && this.isPropertyIncluded(propertyValue, propertyName, propertyTypes[i]);
            if (!isPropertyIncluded) continue;
            if (propertyTypes[i].isComponentType()) {
                this.appendComponentCondition(propertyName, propertyValue, (AbstractComponentType)propertyTypes[i], persistentClass, alias, aliasClasses, sessionFactory, buf);
                continue;
            }
            this.appendPropertyCondition(propertyName, propertyValue, persistentClass, alias, aliasClasses, sessionFactory, buf);
        }
        if (buf.length() == 1) {
            buf.append("1=1");
        }
        return buf.append(")").toString();
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        ClassMetadata meta = sessionFactory.getClassMetadata(persistentClass);
        String[] propertyNames = meta.getPropertyNames();
        Type[] propertyTypes = meta.getPropertyTypes();
        Object[] values = meta.getPropertyValues(this.entity);
        ArrayList list = new ArrayList();
        for (int i = 0; i < propertyNames.length; ++i) {
            boolean isPropertyIncluded;
            Object value = values[i];
            Type type = propertyTypes[i];
            String name = propertyNames[i];
            boolean bl = isPropertyIncluded = i != meta.getVersionProperty() && this.isPropertyIncluded(value, name, type);
            if (!isPropertyIncluded) continue;
            if (propertyTypes[i].isComponentType()) {
                this.addComponentTypedValues(name, value, (AbstractComponentType)type, list);
                continue;
            }
            this.addPropertyTypedValue(value, type, list);
        }
        return (TypedValue[])list.toArray(TYPED_VALUES);
    }

    protected void addPropertyTypedValue(Object value, Type type, List list) {
        if (value != null) {
            if (value instanceof String) {
                String string = (String)value;
                if (this.isIgnoreCaseEnabled) {
                    string = string.toLowerCase();
                }
                if (this.isLikeEnabled) {
                    string = this.matchMode.toMatchString(string);
                }
                value = string;
            }
            list.add(new TypedValue(type, value));
        }
    }

    protected void addComponentTypedValues(String path, Object component, AbstractComponentType type, List list) throws HibernateException {
        if (component != null) {
            String[] propertyNames = type.getPropertyNames();
            Type[] subtypes = type.getSubtypes();
            Object[] values = type.getPropertyValues(component);
            for (int i = 0; i < propertyNames.length; ++i) {
                Object value = values[i];
                Type subtype = subtypes[i];
                String subpath = StringHelper.qualify(path, propertyNames[i]);
                if (!this.isPropertyIncluded(value, subpath, subtype)) continue;
                if (subtype.isComponentType()) {
                    this.addComponentTypedValues(subpath, value, (AbstractComponentType)subtype, list);
                    continue;
                }
                this.addPropertyTypedValue(value, subtype, list);
            }
        }
    }

    protected void appendPropertyCondition(String propertyName, Object propertyValue, Class persistentClass, String alias, Map aliasClasses, SessionFactoryImplementor sessionFactory, StringBuffer buf) throws HibernateException {
        AbstractCriterion crit;
        if (buf.length() > 1) {
            buf.append(" and ");
        }
        if (propertyValue != null) {
            boolean isString = propertyValue instanceof String;
            crit = this.isLikeEnabled && isString ? new LikeExpression(propertyName, propertyValue, this.isIgnoreCaseEnabled) : new EqExpression(propertyName, propertyValue, this.isIgnoreCaseEnabled && isString);
        } else {
            crit = new NullExpression(propertyName);
        }
        buf.append(crit.toSqlString(sessionFactory, persistentClass, alias, aliasClasses));
    }

    protected void appendComponentCondition(String path, Object component, AbstractComponentType type, Class persistentClass, String alias, Map aliasClasses, SessionFactoryImplementor sessionFactory, StringBuffer buf) throws HibernateException {
        if (component != null) {
            String[] propertyNames = type.getPropertyNames();
            Object[] values = type.getPropertyValues(component);
            Type[] subtypes = type.getSubtypes();
            for (int i = 0; i < propertyNames.length; ++i) {
                Object value = values[i];
                String subpath = StringHelper.qualify(path, propertyNames[i]);
                if (!this.isPropertyIncluded(value, subpath, subtypes[i])) continue;
                Type subtype = subtypes[i];
                if (subtype.isComponentType()) {
                    this.appendComponentCondition(subpath, value, (AbstractComponentType)subtype, persistentClass, alias, aliasClasses, sessionFactory, buf);
                    continue;
                }
                this.appendPropertyCondition(subpath, value, persistentClass, alias, aliasClasses, sessionFactory, buf);
            }
        }
    }

    static final class NotNullOrZeroPropertySelector
    implements PropertySelector {
        NotNullOrZeroPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return object != null && (!(object instanceof Number) || ((Number)object).longValue() != 0L);
        }
    }

    static final class NotNullPropertySelector
    implements PropertySelector {
        NotNullPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return object != null;
        }
    }

    static final class AllPropertySelector
    implements PropertySelector {
        AllPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return true;
        }
    }

    public static interface PropertySelector {
        public boolean include(Object var1, String var2, Type var3);
    }
}

