/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.ibator.api.Ibator;
import org.apache.ibatis.ibator.api.VerboseProgressCallback;
import org.apache.ibatis.ibator.config.xml.IbatorConfigurationParser;
import org.apache.ibatis.ibator.exception.InvalidConfigurationException;
import org.apache.ibatis.ibator.exception.XMLParserException;
import org.apache.ibatis.ibator.internal.DefaultShellCallback;
import org.apache.ibatis.ibator.internal.util.messages.Messages;
import org.apache.ibatis.ibator.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatorRunner {
    private static final String CONFIG_FILE = "-configfile";
    private static final String OVERWRITE = "-overwrite";
    private static final String CONTEXT_IDS = "-contextids";
    private static final String TABLES = "-tables";
    private static final String VERBOSE = "-verbose";
    private static final String FORCE_JAVA_LOGGING = "-forceJavaLogging";
    private static final String HELP_1 = "-?";
    private static final String HELP_2 = "-h";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            IbatorRunner.usage();
            System.exit(0);
            return;
        }
        arguments = IbatorRunner.parseCommandLine(args);
        if (arguments.containsKey("-?")) {
            IbatorRunner.usage();
            System.exit(0);
            return;
        }
        if (!arguments.containsKey("-configfile")) {
            IbatorRunner.writeLine(Messages.getString("RuntimeError.0"));
            return;
        }
        warnings = new ArrayList<String>();
        configfile = arguments.get("-configfile");
        configurationFile = new File(configfile);
        if (!configurationFile.exists()) {
            IbatorRunner.writeLine(Messages.getString("RuntimeError.1", configfile));
            return;
        }
        fullyqualifiedTables = new HashSet<String>();
        if (arguments.containsKey("-tables")) {
            st = new StringTokenizer(arguments.get("-tables"), ",");
            while (st.hasMoreTokens()) {
                s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        contexts = new HashSet<String>();
        if (arguments.containsKey("-contextids")) {
            st = new StringTokenizer(arguments.get("-contextids"), ",");
            while (st.hasMoreTokens()) {
                s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contexts.add(s);
            }
        }
        try {
            cp = new IbatorConfigurationParser(warnings);
            config = cp.parseIbatorConfiguration(configurationFile);
            shellCallback = new DefaultShellCallback(arguments.containsKey("-overwrite"));
            ibator = new Ibator(config, shellCallback, warnings);
            progressCallback = arguments.containsKey("-verbose") != false ? new VerboseProgressCallback() : null;
            ibator.generate(progressCallback, contexts, fullyqualifiedTables);
        }
        catch (XMLParserException e) {
            IbatorRunner.writeLine(Messages.getString("Progress.3"));
            IbatorRunner.writeLine();
            ** for (error : e.getErrors())
        }
lbl-1000:
        // 1 sources

        {
            IbatorRunner.writeLine(error);
            continue;
        }
lbl51:
        // 1 sources

        return;
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (InvalidConfigurationException e) {
            IbatorRunner.writeLine(Messages.getString("Progress.16"));
            ** for (error : e.getErrors())
        }
lbl-1000:
        // 1 sources

        {
            IbatorRunner.writeLine(error);
            continue;
        }
lbl63:
        // 1 sources

        return;
        catch (InterruptedException e) {
            // empty catch block
        }
        for (String warning : warnings) {
            IbatorRunner.writeLine(warning);
        }
        if (warnings.size() == 0) {
            IbatorRunner.writeLine(Messages.getString("Progress.4"));
        } else {
            IbatorRunner.writeLine();
            IbatorRunner.writeLine(Messages.getString("Progress.5"));
        }
    }

    private static void usage() {
        String lines = Messages.getString("Usage.Lines");
        int iLines = Integer.parseInt(lines);
        int i = 0;
        while (i < iLines) {
            String key = "Usage." + i;
            IbatorRunner.writeLine(Messages.getString(key));
            ++i;
        }
    }

    private static void writeLine(String message) {
        System.out.println(message);
    }

    private static void writeLine() {
        System.out.println();
    }

    private static Map<String, String> parseCommandLine(String[] args) {
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, String> arguments = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (CONFIG_FILE.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(CONFIG_FILE, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", CONFIG_FILE));
                }
                ++i;
            } else if (OVERWRITE.equalsIgnoreCase(args[i])) {
                arguments.put(OVERWRITE, "Y");
            } else if (VERBOSE.equalsIgnoreCase(args[i])) {
                arguments.put(VERBOSE, "Y");
            } else if (HELP_1.equalsIgnoreCase(args[i])) {
                arguments.put(HELP_1, "Y");
            } else if (HELP_2.equalsIgnoreCase(args[i])) {
                arguments.put(HELP_1, "Y");
            } else if (FORCE_JAVA_LOGGING.equalsIgnoreCase(args[i])) {
                LogFactory.forceJavaLogging();
            } else if (CONTEXT_IDS.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(CONTEXT_IDS, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", CONTEXT_IDS));
                }
                ++i;
            } else if (TABLES.equalsIgnoreCase(args[i])) {
                if (i + 1 < args.length) {
                    arguments.put(TABLES, args[i + 1]);
                } else {
                    errors.add(Messages.getString("RuntimeError.19", TABLES));
                }
                ++i;
            } else {
                errors.add(Messages.getString("RuntimeError.20", args[i]));
            }
            ++i;
        }
        if (!errors.isEmpty()) {
            for (String error : errors) {
                IbatorRunner.writeLine(error);
            }
            System.exit(-1);
        }
        return arguments;
    }
}

