/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.dao.elements;

import java.util.Set;
import java.util.TreeSet;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.Interface;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.AbstractDAOElementGenerator;
import org.apache.ibatis.ibator.internal.util.JavaBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectByPrimaryKeyMethodGenerator
extends AbstractDAOElementGenerator {
    @Override
    public void addImplementationElements(TopLevelClass topLevelClass) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        StringBuilder sb = new StringBuilder();
        if (!this.introspectedTable.getRules().generatePrimaryKeyClass()) {
            FullyQualifiedJavaType keyType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
            topLevelClass.addImportedType(keyType);
            sb.setLength(0);
            sb.append(keyType.getShortName());
            sb.append(" _key = new ");
            sb.append(keyType.getShortName());
            sb.append("();");
            method.addBodyLine(sb.toString());
            for (IntrospectedColumn introspectedColumn : this.introspectedTable.getPrimaryKeyColumns()) {
                sb.setLength(0);
                sb.append("_key.");
                sb.append(JavaBeansUtil.getSetterMethodName(introspectedColumn.getJavaProperty()));
                sb.append('(');
                sb.append(introspectedColumn.getJavaProperty());
                sb.append(");");
                method.addBodyLine(sb.toString());
            }
        }
        FullyQualifiedJavaType returnType = method.getReturnType();
        sb.setLength(0);
        sb.append("Object obj = ");
        sb.append(this.daoTemplate.getQueryForObjectMethod(this.introspectedTable.getIbatis2SqlMapNamespace(), this.introspectedTable.getSelectByPrimaryKeyStatementId(), "_key"));
        method.addBodyLine(sb.toString());
        method.addBodyLine("if(!(obj instanceof " + returnType.getShortName() + "))");
        method.addBodyLine("return null; ");
        sb.setLength(0);
        sb.append(returnType.getShortName());
        sb.append(" record = (");
        sb.append(returnType.getShortName());
        sb.append(") obj;");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append("return record;");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        if (this.ibatorContext.getPlugins().daoSelectByPrimaryKeyMethodGenerated(method, topLevelClass, this.introspectedTable)) {
            topLevelClass.addImportedTypes(importedTypes);
            topLevelClass.addMethod(method);
        }
    }

    @Override
    public void addInterfaceElements(Interface interfaze) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        if (this.ibatorContext.getPlugins().daoSelectByPrimaryKeyMethodGenerated(method, interfaze, this.introspectedTable)) {
            interfaze.addImportedTypes(importedTypes);
            interfaze.addMethod(method);
        }
    }

    private Method getMethodShell(Set<FullyQualifiedJavaType> importedTypes) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType returnType = this.introspectedTable.getRules().calculateAllFieldsClass();
        method.setReturnType(returnType);
        importedTypes.add(returnType);
        method.setName(this.getDAOMethodNameCalculator().getSelectByPrimaryKeyMethodName(this.introspectedTable));
        if (this.introspectedTable.getRules().generatePrimaryKeyClass()) {
            FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getPrimaryKeyType());
            importedTypes.add(type);
            method.addParameter(new Parameter(type, "_key"));
        } else {
            for (IntrospectedColumn introspectedColumn : this.introspectedTable.getPrimaryKeyColumns()) {
                FullyQualifiedJavaType type = introspectedColumn.getFullyQualifiedJavaType();
                importedTypes.add(type);
                method.addParameter(new Parameter(type, introspectedColumn.getJavaProperty()));
            }
        }
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getCheckedExceptions()) {
            method.addException(fqjt);
            importedTypes.add(fqjt);
        }
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u6839\u636e\u4e3b\u952e\u67e5\u8be2");
        return method;
    }
}

