/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal;

import java.util.List;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.IbatorPlugin;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.JavaTypeResolver;
import org.apache.ibatis.ibator.config.CommentGeneratorConfiguration;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.config.IbatorPluginConfiguration;
import org.apache.ibatis.ibator.config.JavaTypeResolverConfiguration;
import org.apache.ibatis.ibator.config.TableConfiguration;
import org.apache.ibatis.ibator.generator.ibatis2.IntrospectedTableIbatis2Java2Impl;
import org.apache.ibatis.ibator.generator.ibatis2.IntrospectedTableIbatis2Java5Impl;
import org.apache.ibatis.ibator.generator.ibatis3.IntrospectedTableIbatis3Impl;
import org.apache.ibatis.ibator.internal.DefaultCommentGenerator;
import org.apache.ibatis.ibator.internal.types.JavaTypeResolverDefaultImpl;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatorObjectFactory {
    private static ClassLoader externalClassLoader;

    private IbatorObjectFactory() {
    }

    private static ClassLoader getClassLoader() {
        if (externalClassLoader != null) {
            return externalClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static synchronized void setExternalClassLoader(ClassLoader classLoader) {
        externalClassLoader = classLoader;
    }

    public static Class<?> externalClassForName(String type) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = IbatorObjectFactory.getClassLoader().loadClass(type);
        }
        catch (Throwable e) {
            clazz = null;
        }
        if (clazz == null) {
            clazz = Class.forName(type);
        }
        return clazz;
    }

    public static Object createExternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = IbatorObjectFactory.externalClassForName(type);
            answer = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static Class<?> internalClassForName(String type) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = cl.loadClass(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(type);
        }
        return clazz;
    }

    public static Object createInternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = IbatorObjectFactory.internalClassForName(type);
            answer = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static JavaTypeResolver createJavaTypeResolver(IbatorContext context, List<String> warnings) {
        String type;
        JavaTypeResolverConfiguration config = context.getJavaTypeResolverConfiguration();
        if (config != null && config.getConfigurationType() != null) {
            type = config.getConfigurationType();
            if ("DEFAULT".equalsIgnoreCase(type)) {
                type = JavaTypeResolverDefaultImpl.class.getName();
            }
        } else {
            type = JavaTypeResolverDefaultImpl.class.getName();
        }
        JavaTypeResolver answer = (JavaTypeResolver)IbatorObjectFactory.createInternalObject(type);
        answer.setWarnings(warnings);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        answer.setIbatorContext(context);
        return answer;
    }

    public static IbatorPlugin createIbatorPlugin(IbatorContext ibatorContext, IbatorPluginConfiguration ibatorPluginConfiguration) {
        IbatorPlugin ibatorPlugin = (IbatorPlugin)IbatorObjectFactory.createInternalObject(ibatorPluginConfiguration.getConfigurationType());
        ibatorPlugin.setIbatorContext(ibatorContext);
        ibatorPlugin.setProperties(ibatorPluginConfiguration.getProperties());
        return ibatorPlugin;
    }

    public static CommentGenerator createCommentGenerator(IbatorContext context) {
        CommentGeneratorConfiguration config = context.getCommentGeneratorConfiguration();
        String type = config == null || config.getConfigurationType() == null ? DefaultCommentGenerator.class.getName() : config.getConfigurationType();
        CommentGenerator answer = (CommentGenerator)IbatorObjectFactory.createInternalObject(type);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        return answer;
    }

    public static IntrospectedTable createIntrospectedTable(TableConfiguration tableConfiguration, FullyQualifiedTable table, IbatorContext ibatorContext) {
        String type = ibatorContext.getTargetRuntime();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedTableIbatis2Java2Impl.class.getName();
        } else if ("Ibatis2Java2".equalsIgnoreCase(type)) {
            type = IntrospectedTableIbatis2Java2Impl.class.getName();
        } else if ("Ibatis2Java5".equalsIgnoreCase(type)) {
            type = IntrospectedTableIbatis2Java5Impl.class.getName();
        } else if ("Ibatis3".equalsIgnoreCase(type)) {
            type = IntrospectedTableIbatis3Impl.class.getName();
        }
        IntrospectedTable answer = (IntrospectedTable)IbatorObjectFactory.createInternalObject(type);
        answer.setFullyQualifiedTable(table);
        answer.setIbatorContext(ibatorContext);
        answer.setTableConfiguration(tableConfiguration);
        return answer;
    }

    public static IntrospectedColumn createIntrospectedColumn(IbatorContext ibatorContext) {
        String type = ibatorContext.getIntrospectedColumnImpl();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedColumn.class.getName();
        }
        IntrospectedColumn answer = (IntrospectedColumn)IbatorObjectFactory.createInternalObject(type);
        answer.setIbatorContext(ibatorContext);
        return answer;
    }
}

