/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jca;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionMetaData;
import net.sf.hibernate.jca.ManagedConnectionImpl;

public class MetaDataImpl
implements ManagedConnectionMetaData {
    private ManagedConnectionImpl mc;

    public MetaDataImpl(ManagedConnectionImpl mc) {
        this.mc = mc;
    }

    public String getEISProductName() throws ResourceException {
        String result = null;
        try {
            result = this.mc.getSqlConnection().getMetaData().getUserName();
        }
        catch (SQLException e) {
            String message = "Exception getting product name";
            ResourceException re = new ResourceException("Exception getting product name");
            re.setLinkedException((Exception)e);
            throw re;
        }
        return result;
    }

    public String getEISProductVersion() throws ResourceException {
        String result = null;
        try {
            result = this.mc.getSqlConnection().getMetaData().getDriverVersion();
        }
        catch (SQLException e) {
            String message = "Exception getting product version";
            ResourceException re = new ResourceException("Exception getting product version");
            re.setLinkedException((Exception)e);
            throw re;
        }
        return result;
    }

    public int getMaxConnections() throws ResourceException {
        int result = 0;
        try {
            result = this.mc.getSqlConnection().getMetaData().getMaxConnections();
        }
        catch (SQLException e) {
            String message = "Exception getting max connections";
            ResourceException re = new ResourceException("Exception getting max connections");
            re.setLinkedException((Exception)e);
            throw re;
        }
        return result;
    }

    public String getUserName() throws ResourceException {
        String result = null;
        try {
            result = this.mc.getSqlConnection().getMetaData().getUserName();
        }
        catch (SQLException e) {
            String message = "Exception getting connection user name";
            ResourceException re = new ResourceException("Exception getting connection user name");
            re.setLinkedException((Exception)e);
            throw re;
        }
        return result;
    }
}

