/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.exception;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.exception.Configurable;
import net.sf.hibernate.exception.GenericJDBCException;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLExceptionConverterFactory {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$exception$SQLExceptionConverterFactory == null ? (class$net$sf$hibernate$exception$SQLExceptionConverterFactory = SQLExceptionConverterFactory.class$("net.sf.hibernate.exception.SQLExceptionConverterFactory")) : class$net$sf$hibernate$exception$SQLExceptionConverterFactory));
    static /* synthetic */ Class class$net$sf$hibernate$exception$SQLExceptionConverterFactory;
    static /* synthetic */ Class class$net$sf$hibernate$exception$ViolatedConstraintNameExtracter;

    public static SQLExceptionConverter buildSQLExceptionConverter(Dialect dialect, Properties properties) throws HibernateException {
        SQLExceptionConverter converter = null;
        String converterClassName = (String)properties.get("hibernate.sql_exception_converter");
        if (StringHelper.isNotEmpty(converterClassName)) {
            converter = SQLExceptionConverterFactory.constructConverter(converterClassName, dialect.getViolatedConstraintNameExtracter());
        }
        if (converter == null) {
            log.trace((Object)"Using dialect defined converter");
            converter = dialect.buildSQLExceptionConverter();
        }
        if (converter instanceof Configurable) {
            try {
                ((Configurable)((Object)converter)).configure(properties);
            }
            catch (HibernateException e) {
                log.warn((Object)"Unable to configure SQLExceptionConverter", (Throwable)e);
                throw e;
            }
        }
        return converter;
    }

    public static SQLExceptionConverter buildMinimalSQLExceptionConverter() {
        return new SQLExceptionConverter(){

            public JDBCException convert(SQLException sqlException, String message) {
                return new GenericJDBCException(message, sqlException);
            }
        };
    }

    private static SQLExceptionConverter constructConverter(String converterClassName, ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        try {
            log.trace((Object)("Attempting to construct instance of specified SQLExceptionConverter [" + converterClassName + "]"));
            Class converterClass = ReflectHelper.classForName(converterClassName);
            Constructor<?>[] ctors = converterClass.getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                if (ctors[i].getParameterTypes() == null || ctors[i].getParameterTypes().length != 1 || !(class$net$sf$hibernate$exception$ViolatedConstraintNameExtracter == null ? SQLExceptionConverterFactory.class$("net.sf.hibernate.exception.ViolatedConstraintNameExtracter") : class$net$sf$hibernate$exception$ViolatedConstraintNameExtracter).isAssignableFrom(ctors[i].getParameterTypes()[0])) continue;
                try {
                    return (SQLExceptionConverter)ctors[i].newInstance(violatedConstraintNameExtracter);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return (SQLExceptionConverter)converterClass.newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to construct instance of specified SQLExceptionConverter", t);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

