/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class MessageVelocityEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(MessageVelocityEngine.class);
    private static final String DATADIR = "dataDir";
    private static final String MESSAGEDIR = "messageDir";
    private static final String MESSAGETEMPLATE = "messageTemplate";

    public static void main(String[] args) throws Exception {
        List<CodeInfo> list = MessageVelocityEngine.findDesigner(MessageVelocityEngine.getDir(DATADIR));
        for (int i = 0; i < list.size(); ++i) {
            MessageVelocityEngine.messageGenerator(list.get(i));
        }
    }

    public static void messageGenerator(CodeInfo codeinfo) {
        String messageTemplate = MessageVelocityEngine.getSysProperty(MESSAGETEMPLATE);
        File file = new File(messageTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + messageTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = MessageVelocityEngine.obj2Map(codeinfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String messageDir = MessageVelocityEngine.getDir(MESSAGEDIR);
                String fileName = "returncode-" + codeinfo.getCode() + ".properties";
                String fileNameZH = "returncode-" + codeinfo.getCode() + "_zh_CN.properties";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, messageTemplate), messageDir + "/" + fileName);
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, messageTemplate), messageDir + "/" + fileNameZH);
            }
            catch (Exception var8) {
                logger.error((Object)"\u751f\u6210\u679a\u4e3e\u7c7b\u9519\u8bef:", (Throwable)var8);
            }
        }
    }
}

