/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.util;

import com.miniframe.designer.util.ClassPropertyMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.property.BasicPropertyAccessor;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.property.Setter;

public class ClassAnalysis {
    private Class analysisClass;
    private List propertys = new ArrayList();
    private List propMeatList = new ArrayList();
    private String[] getterNames;
    private String[] setterNames;
    private Getter[] getters;
    private Setter[] setters;
    private Class[] propTypes;
    private String[] propertyNames;

    public ClassAnalysis(Class clazz) {
        this.analysisClass = clazz;
        this.getPropertys(this.analysisClass);
        Iterator itr = this.propertys.iterator();
        BasicPropertyAccessor propertyAccessor = new BasicPropertyAccessor();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            ClassPropertyMeta propertyMeta = new ClassPropertyMeta();
            try {
                String propertyName = field.getName();
                propertyMeta.setProperty(field);
                propertyMeta.setGetter(propertyAccessor.getGetter(clazz, propertyName));
                propertyMeta.setSetter(propertyAccessor.getSetter(clazz, propertyName));
                propertyMeta.setPropType(propertyMeta.getGetter().getReturnType());
                this.propMeatList.add(propertyMeta);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        }
        this.convertToAry();
    }

    private void getPropertys(Class clazz) {
        if (clazz != null && clazz != Object.class) {
            Class curClass = clazz.getSuperclass();
            this.getPropertys(curClass);
            Field[] fileds = clazz.getDeclaredFields();
            for (int i = 0; i < fileds.length; ++i) {
                this.propertys.add(fileds[i]);
            }
        }
    }

    private void convertToAry() {
        int properspan = this.propMeatList.size();
        this.getters = new Getter[properspan];
        this.getterNames = new String[properspan];
        this.setterNames = new String[properspan];
        this.setters = new Setter[properspan];
        this.propTypes = new Class[properspan];
        this.propertyNames = new String[properspan];
        Iterator itr = this.propMeatList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            String propertyName;
            ClassPropertyMeta propertyMeta = (ClassPropertyMeta)itr.next();
            if (propertyMeta == null) continue;
            this.propertyNames[i] = propertyName = propertyMeta.getProperty().getName();
            this.getters[i] = propertyMeta.getGetter();
            this.setters[i] = propertyMeta.getSetter();
            this.propTypes[i] = this.getters[i].getReturnType();
            this.getterNames[i] = this.getters[i].getMethodName();
            this.setterNames[i] = this.setters[i].getMethodName();
            ++i;
        }
    }

    public Getter[] getGetters() {
        return this.getters;
    }

    public Setter[] getSetters() {
        return this.setters;
    }

    public Class[] getPropTypes() {
        return this.propTypes;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String[] getGetterNames() {
        return this.getterNames;
    }

    public String[] getSetterNames() {
        return this.setterNames;
    }

    public static void main(String[] args) {
    }

    public Class getAnalysisClass() {
        return this.analysisClass;
    }
}

