/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.util;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class DesignerTools {
    private static String startCode = "100000";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getUUID() {
        return "\"" + UUID.randomUUID().toString().replace("-", "") + "\"";
    }

    public static boolean isClientApater(Map map) {
        if (map.get("map") == null) {
            return false;
        }
        Map map1 = (Map)map.get("map");
        return map1.get("commType") != null && map1.get("transmitter") != null;
    }

    public static boolean isClientComm(Map map) {
        if (map.get("map") == null) {
            return false;
        }
        Map map1 = (Map)map.get("map");
        return map1.get("transType") != null;
    }

    public static boolean isServerApater(Map map) {
        if (map.get("map") == null) {
            return false;
        }
        Map map1 = (Map)map.get("map");
        return map1.get("commType") != null && map1.get("transmitter") == null;
    }

    public static boolean importUtil(Map map) {
        String itemtype;
        Object key;
        Object value;
        Iterator keys = map.keySet().iterator();
        do {
            if (keys.hasNext()) continue;
            return false;
        } while (!((value = map.get(key = keys.next())) instanceof Map) || (itemtype = (String)((Map)value).get("\u6570\u636e\u7c7b\u578b")) == null || itemtype.indexOf("date") < 0 && itemtype.indexOf("list") < 0);
        return true;
    }

    public static boolean importMath(Map map) {
        for (Object key : map.keySet()) {
            String itemtype;
            Object value = map.get(key);
            if (!(value instanceof Map) || (itemtype = (String)((Map)value).get("\u6570\u636e\u7c7b\u578b")) == null || itemtype.indexOf("decimal") < 0) continue;
            return true;
        }
        return false;
    }

    public static String getClassName(String str) {
        return DesignerTools.isNotNullAndBlank(str) ? str.trim().toUpperCase() : null;
    }

    public static boolean isUp(String str) {
        return DesignerTools.isNotNullAndBlank(str) ? str.trim().toLowerCase().startsWith("a_") : false;
    }

    public static boolean isDn(String str) {
        return DesignerTools.isNotNullAndBlank(str) ? str.trim().toLowerCase().startsWith("d_") : false;
    }

    public static boolean isReferred(String str) {
        return DesignerTools.isNotNullAndBlank(str) ? str.trim().startsWith("#") : false;
    }

    public static boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    public static String unCamelName(String name) {
        StringBuilder result = new StringBuilder();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toUpperCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase()) && !Character.isDigit(s.charAt(0))) {
                    result.append("_");
                }
                result.append(s.toUpperCase());
            }
        }
        return result.toString();
    }

    public static String camelName(String name) {
        StringBuilder result = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            String[] camels;
            if (!name.contains("_")) {
                return name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            String[] var6 = camels = name.split("_");
            int var5 = camels.length;
            for (int var4 = 0; var4 < var5; ++var4) {
                String camel = var6[var4];
                if (camel.isEmpty()) continue;
                if (result.length() == 0) {
                    result.append(camel.toLowerCase());
                    continue;
                }
                result.append(camel.substring(0, 1).toUpperCase());
                result.append(camel.substring(1).toLowerCase());
            }
            return result.toString();
        }
        return "";
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        if (str.trim().equals("")) {
            return false;
        }
        if (str.trim().startsWith("int")) {
            return true;
        }
        if (str.trim().startsWith("long")) {
            return true;
        }
        if (str.trim().startsWith("short")) {
            return true;
        }
        if (str.trim().startsWith("float")) {
            return true;
        }
        if (str.trim().startsWith("double")) {
            return true;
        }
        if (str.trim().startsWith("decimal")) {
            return true;
        }
        return str.trim().startsWith("bigdecimal");
    }

    public static boolean isNullAndBlank(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    public static boolean isNotNull(Object obj) {
        return obj != null;
    }

    public Object get(Map map, Object key1) {
        if (key1 instanceof String) {
            String key = (String)key1;
            int idx = key.indexOf(".");
            if (idx == -1) {
                return map.get(key);
            }
            String curKey = key.substring(0, idx);
            String subKey = key.substring(idx + 1, key.length());
            Object obj = map.get(curKey);
            if (obj == null) {
                return null;
            }
            Map map1 = (Map)obj;
            return this.get(map1, subKey);
        }
        return map.get(key1);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        return str1.toLowerCase().trim().equals(str2.toLowerCase().trim());
    }

    public static boolean isNotNullAndBlank(String str) {
        return !DesignerTools.isNullAndBlank(str);
    }

    public static String getStringDepends(String required, String minlength, String maxlength, String mask, String datacriterion) {
        String retStr = "";
        if (DesignerTools.toBool(required)) {
            retStr = retStr + "required,";
        }
        if (DesignerTools.isNotNullAndBlank(minlength)) {
            retStr = retStr + "minlength,";
        }
        if (DesignerTools.isNotNullAndBlank(maxlength)) {
            retStr = retStr + "maxlength,";
        }
        if (DesignerTools.isNotNullAndBlank(mask)) {
            retStr = retStr + "mask,";
        }
        if (DesignerTools.isNotNullAndBlank(datacriterion)) {
            retStr = retStr + "datacriterion,";
        }
        if ((retStr = retStr.trim()).endsWith(",")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        return retStr;
    }

    public static String getNumberDepends(String required, String min, String max, String mask, String datacriterion) {
        String retStr = "";
        if (DesignerTools.toBool(required)) {
            retStr = retStr + "required,";
        }
        if (DesignerTools.isNotNullAndBlank(min) || DesignerTools.isNotNullAndBlank(max)) {
            retStr = retStr + "range,";
        }
        if (DesignerTools.isNotNullAndBlank(mask)) {
            retStr = retStr + "mask,";
        }
        if (DesignerTools.isNotNullAndBlank(datacriterion)) {
            retStr = retStr + "datacriterion,";
        }
        if ((retStr = retStr.trim()).endsWith(",")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        return retStr;
    }

    public static String package2Dir(String str) {
        return str == null ? null : str.replace(".", "/");
    }

    public static boolean toBool(String str) {
        if (str == null) {
            return false;
        }
        if (str.trim().equals("")) {
            return false;
        }
        if (str.trim().equals("1")) {
            return true;
        }
        if (str.trim().toLowerCase().equals("yes")) {
            return true;
        }
        if (str.trim().toLowerCase().equals("true")) {
            return true;
        }
        if (str.trim().equals("\u662f")) {
            return true;
        }
        return str.trim().equals("\u771f");
    }

    public static String str2Unicode(String theString) {
        boolean escapeSpace = false;
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case '\t': {
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('n');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('f');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('r');
                    continue block8;
                }
                case ' ': {
                    if (x != 0 && !escapeSpace) continue block8;
                    outBuffer.append(' ');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar >= ' ' && aChar <= '~') {
                        outBuffer.append(aChar);
                        continue block8;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('u');
                    outBuffer.append(DesignerTools.toHex(aChar >> 12 & 0xF));
                    outBuffer.append(DesignerTools.toHex(aChar >> 8 & 0xF));
                    outBuffer.append(DesignerTools.toHex(aChar >> 4 & 0xF));
                    outBuffer.append(DesignerTools.toHex(aChar & 0xF));
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String getIndex(int code) {
        String codeString = String.valueOf(code);
        return codeString.length() == startCode.length() ? codeString : startCode.substring(0, startCode.length() - codeString.length()) + codeString;
    }

    public static String getIndex(String code) {
        if (code == null) {
            return null;
        }
        return code.length() == startCode.length() ? code : startCode.substring(0, startCode.length() - code.length()) + code;
    }

    public static String capName(String name) {
        if (name == null) {
            return null;
        }
        String tmp = name.trim();
        tmp = tmp.substring(0, 1).toUpperCase() + name.substring(1);
        return tmp;
    }

    public static String lowName(String name) {
        if (name == null) {
            return null;
        }
        String tmp = name.trim();
        tmp = tmp.substring(0, 1).toLowerCase() + name.substring(1);
        return tmp;
    }

    public static String toLower(String name) {
        return name == null ? null : name.toLowerCase();
    }

    public static String toUpper(String name) {
        return name == null ? null : name.toUpperCase();
    }

    public static String getValedateType(String name) {
        if (name == null) {
            return "string";
        }
        String tmp = name.trim().toLowerCase();
        if (tmp.equals("")) {
            return "string";
        }
        if (tmp.startsWith("str")) {
            return "string";
        }
        if (tmp.startsWith("short")) {
            return "short";
        }
        if (tmp.startsWith("int")) {
            return "integer";
        }
        if (tmp.startsWith("long")) {
            return "long";
        }
        if (tmp.startsWith("float")) {
            return "float";
        }
        return tmp.startsWith("double") ? "double" : name;
    }

    public static String getDataType(String name) {
        if (name == null) {
            return "String";
        }
        String tmp = name.trim().toLowerCase();
        if (tmp.equals("")) {
            return "String";
        }
        if (tmp.startsWith("str")) {
            return "String";
        }
        if (tmp.startsWith("int")) {
            return "int";
        }
        if (tmp.startsWith("lon")) {
            return "long";
        }
        return !tmp.startsWith("dec") && !tmp.startsWith("big") && !tmp.startsWith("mon") ? "String" : "BigDecimal";
    }

    public static boolean isString(String name) {
        if (name == null) {
            return true;
        }
        String tmp = name.trim().toLowerCase();
        if (tmp.equals("")) {
            return true;
        }
        if (tmp.startsWith("str")) {
            return true;
        }
        if (tmp.startsWith("int")) {
            return false;
        }
        if (tmp.startsWith("lon")) {
            return false;
        }
        return !tmp.startsWith("dec") && !tmp.startsWith("big") && !tmp.startsWith("mon");
    }
}

