/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class TransFlowEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(TransFlowEngine.class);
    private String dataDir;
    private String sqlFile;
    private String sqlTemplate;
    private String xmlFile;
    private String xmlTemplate;
    private String msgDir;
    private String msgTemplate;
    private String serviceDir;
    private String serviceTemplate;
    private String executeTemplate;

    public static void main(String[] args) throws Exception {
        TransFlowEngine engine = new TransFlowEngine();
        engine.setDataDir(MiniVelocityEngine.getDir("dataDir"));
        engine.setSqlFile(MiniVelocityEngine.getSysProperty("sqlFile"));
        engine.setSqlTemplate(MiniVelocityEngine.getSysProperty("sqlTemplate"));
        engine.setXmlFile(MiniVelocityEngine.getSysProperty("xmlFile"));
        engine.setXmlTemplate(MiniVelocityEngine.getSysProperty("xmlTemplate"));
        engine.setMsgDir(MiniVelocityEngine.getDir("msgDir"));
        engine.setMsgTemplate(MiniVelocityEngine.getSysProperty("msgTemplate"));
        engine.setServiceDir(MiniVelocityEngine.getDir("serviceDir"));
        engine.setServiceTemplate(MiniVelocityEngine.getSysProperty("serviceTemplate"));
        engine.setExecuteTemplate(MiniVelocityEngine.getSysProperty("executeTemplate"));
        List<CodeInfo> list = TransFlowEngine.findDesigner(engine.getDataDir());
        engine.sqlGenerator(list);
        engine.xmlGenerator(list);
        for (int i = 0; i < list.size(); ++i) {
            CodeInfo info = list.get(i);
            for (int j = 0; j < info.getList().size(); ++j) {
                Map<String, String> map = info.getList().get(j);
                map.put("code", info.getCode());
                map.put("name", info.getName());
                engine.msgGenerator(map);
                if (map.get("\u5c5e\u6027").trim().equals("service")) {
                    engine.serviceGenerator(map);
                    continue;
                }
                if (!map.get("\u5c5e\u6027").trim().equals("execute")) continue;
                engine.executeGenerator(map);
            }
        }
    }

    public void executeGenerator(Map<String, String> map) {
        File file = new File(this.executeTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.executeTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String servieFile = this.serviceDir + "com/miniframe/bisiness/" + map.get("code").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Service.java";
                File file1 = new File(servieFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.executeTemplate), servieFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210serviceTemplate\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void serviceGenerator(Map<String, String> map) {
        File file = new File(this.serviceTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.serviceTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String servieFile = this.serviceDir + "com/miniframe/bisiness/" + map.get("code").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Service.java";
                File file1 = new File(servieFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.serviceTemplate), servieFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210serviceTemplate\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void msgGenerator(Map<String, String> map) {
        File file = new File(this.msgTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.msgTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String msgFile1 = this.msgDir + "resources_DESIGN_" + map.get("code") + "_" + map.get("\u4ea4\u6613\u7f16\u7801") + "_zh_CN.properties";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.msgTemplate), msgFile1);
                String msgFile2 = this.msgDir + "resources_DESIGN_" + map.get("code") + "_" + map.get("\u4ea4\u6613\u7f16\u7801") + ".properties";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.msgTemplate), msgFile2);
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210\u8d44\u6e90\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void xmlGenerator(List<CodeInfo> list) {
        File file = new File(this.xmlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.xmlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Map<?, ?> map = TransFlowEngine.obj2Map(list.get(i));
                mapList.add(map);
            }
            logger.error((Object)("--->" + mapList));
            ctx.put("list", mapList);
            try {
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.xmlTemplate), this.xmlFile);
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210xml\u9519\u8bef:", (Throwable)var7);
            }
        }
    }

    public void sqlGenerator(List<CodeInfo> list) {
        File file = new File(this.sqlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.sqlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Map<?, ?> map = TransFlowEngine.obj2Map(list.get(i));
                mapList.add(map);
            }
            logger.error((Object)("--->" + mapList));
            ctx.put("list", mapList);
            try {
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.sqlTemplate), this.sqlFile);
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210SQL\u9519\u8bef:", (Throwable)var7);
            }
        }
    }

    public String getSqlFile() {
        return this.sqlFile;
    }

    public void setSqlFile(String sqlFile) {
        this.sqlFile = sqlFile;
    }

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    public void setSqlTemplate(String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getXmlTemplate() {
        return this.xmlTemplate;
    }

    public void setXmlTemplate(String xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }

    public String getMsgDir() {
        return this.msgDir;
    }

    public void setMsgDir(String msgDir) {
        this.msgDir = msgDir;
    }

    public String getMsgTemplate() {
        return this.msgTemplate;
    }

    public void setMsgTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
    }

    public String getServiceDir() {
        return this.serviceDir;
    }

    public void setServiceDir(String serviceDir) {
        this.serviceDir = serviceDir;
    }

    public String getServiceTemplate() {
        return this.serviceTemplate;
    }

    public void setServiceTemplate(String serviceTemplate) {
        this.serviceTemplate = serviceTemplate;
    }

    public String getExecuteTemplate() {
        return this.executeTemplate;
    }

    public void setExecuteTemplate(String executeTemplate) {
        this.executeTemplate = executeTemplate;
    }
}

