/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis3;

import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.internal.util.StringUtility;

public class Ibatis3FormattingUtilities {
    private Ibatis3FormattingUtilities() {
    }

    public static String getParameterClause(IntrospectedColumn introspectedColumn) {
        return Ibatis3FormattingUtilities.getParameterClause(introspectedColumn, null);
    }

    public static String getParameterClause(IntrospectedColumn introspectedColumn, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("#{");
        sb.append(introspectedColumn.getJavaProperty(prefix));
        sb.append(",jdbcType=");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append(",typeHandler=");
            sb.append(introspectedColumn.getTypeHandler());
        }
        sb.append('}');
        return sb.toString();
    }

    public static String getSelectListPhrase(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(Ibatis3FormattingUtilities.getAliasedEscapedColumnName(introspectedColumn));
            sb.append(" as ");
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(introspectedColumn.getIbatorContext().getBeginningDelimiter());
            }
            sb.append(introspectedColumn.getTableAlias());
            sb.append('_');
            sb.append(Ibatis3FormattingUtilities.escapeStringForIbatis3(introspectedColumn.getActualColumnName()));
            if (introspectedColumn.isColumnNameDelimited()) {
                sb.append(introspectedColumn.getIbatorContext().getEndingDelimiter());
            }
            return sb.toString();
        }
        return Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
    }

    public static String getEscapedColumnName(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append(Ibatis3FormattingUtilities.escapeStringForIbatis3(introspectedColumn.getActualColumnName()));
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.insert(0, introspectedColumn.getIbatorContext().getBeginningDelimiter());
            sb.append(introspectedColumn.getIbatorContext().getEndingDelimiter());
        }
        return sb.toString();
    }

    public static String getAliasedEscapedColumnName(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(introspectedColumn.getTableAlias());
            sb.append('.');
            sb.append(Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn));
            return sb.toString();
        }
        return Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn);
    }

    public static String getAliasedActualColumnName(IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            sb.append(introspectedColumn.getTableAlias());
            sb.append('.');
        }
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getIbatorContext().getBeginningDelimiter()));
        }
        sb.append(introspectedColumn.getActualColumnName());
        if (introspectedColumn.isColumnNameDelimited()) {
            sb.append(StringUtility.escapeStringForJava(introspectedColumn.getIbatorContext().getEndingDelimiter()));
        }
        return sb.toString();
    }

    public static String getRenamedColumnNameForResultMap(IntrospectedColumn introspectedColumn) {
        if (StringUtility.stringHasValue(introspectedColumn.getTableAlias())) {
            StringBuilder sb = new StringBuilder();
            sb.append(introspectedColumn.getTableAlias());
            sb.append('_');
            sb.append(introspectedColumn.getActualColumnName());
            return sb.toString();
        }
        return introspectedColumn.getActualColumnName();
    }

    public static String escapeStringForIbatis3(String s) {
        return s;
    }
}

