/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.ProgressCallback;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.generator.AbstractGenerator;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.AbstractXmlGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.DAOGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.GenericCIDAOTemplate;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.GenericSIDAOTemplate;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.IbatisDAOTemplate;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.SpringDAOTemplate;
import org.apache.ibatis.ibator.generator.ibatis2.model.BaseRecordGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.model.ExampleGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.model.PrimaryKeyGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.model.RecordWithBLOBsGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.SqlMapGenerator;
import org.apache.ibatis.ibator.internal.IbatorObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectedTableIbatis2Java2Impl
extends IntrospectedTable {
    protected List<AbstractJavaGenerator> javaModelGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> daoGenerators = new ArrayList<AbstractJavaGenerator>();
    protected AbstractXmlGenerator sqlMapGenerator;

    public IntrospectedTableIbatis2Java2Impl() {
        super(IntrospectedTable.TargetRuntime.IBATIS2);
    }

    @Override
    public void calculateGenerators(List<String> warnings, ProgressCallback progressCallback) {
        this.calculateJavaModelGenerators(warnings, progressCallback);
        this.calculateDAOGenerators(warnings, progressCallback);
        this.calculateSqlMapGenerator(warnings, progressCallback);
    }

    protected void calculateSqlMapGenerator(List<String> warnings, ProgressCallback progressCallback) {
        this.sqlMapGenerator = new SqlMapGenerator();
        this.initializeAbstractGenerator(this.sqlMapGenerator, warnings, progressCallback);
    }

    protected void calculateDAOGenerators(List<String> warnings, ProgressCallback progressCallback) {
        if (this.ibatorContext.getDaoGeneratorConfiguration() == null) {
            return;
        }
        String type = this.ibatorContext.getDaoGeneratorConfiguration().getConfigurationType();
        AbstractJavaGenerator javaGenerator = "IBATIS".equalsIgnoreCase(type) ? new DAOGenerator(new IbatisDAOTemplate(), this.isJava5Targeted()) : ("SPRING".equalsIgnoreCase(type) ? new DAOGenerator(new SpringDAOTemplate(), this.isJava5Targeted()) : ("GENERIC-CI".equalsIgnoreCase(type) ? new DAOGenerator(new GenericCIDAOTemplate(), this.isJava5Targeted()) : ("GENERIC-SI".equalsIgnoreCase(type) ? new DAOGenerator(new GenericSIDAOTemplate(), this.isJava5Targeted()) : (AbstractJavaGenerator)IbatorObjectFactory.createInternalObject(type))));
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.daoGenerators.add(javaGenerator);
    }

    protected void calculateJavaModelGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator;
        if (this.getRules().generateExampleClass()) {
            javaGenerator = new ExampleGenerator(this.isJava5Targeted());
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generatePrimaryKeyClass()) {
            javaGenerator = new PrimaryKeyGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateBaseRecordClass()) {
            javaGenerator = new BaseRecordGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateRecordWithBLOBsClass()) {
            javaGenerator = new RecordWithBLOBsGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
    }

    protected void initializeAbstractGenerator(AbstractGenerator abstractGenerator, List<String> warnings, ProgressCallback progressCallback) {
        abstractGenerator.setIbatorContext(this.ibatorContext);
        abstractGenerator.setIntrospectedTable(this);
        abstractGenerator.setProgressCallback(progressCallback);
        abstractGenerator.setWarnings(warnings);
    }

    @Override
    public List<GeneratedJavaFile> getGeneratedJavaFiles() {
        GeneratedJavaFile gjf;
        List<CompilationUnit> compilationUnits;
        ArrayList<GeneratedJavaFile> answer = new ArrayList<GeneratedJavaFile>();
        for (AbstractJavaGenerator javaGenerator : this.javaModelGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.ibatorContext.getJavaModelGeneratorConfiguration().getTargetProject());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.daoGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.ibatorContext.getDaoGeneratorConfiguration().getTargetProject());
                answer.add(gjf);
            }
        }
        return answer;
    }

    @Override
    public List<GeneratedXmlFile> getGeneratedXmlFiles() {
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>();
        Document document = this.sqlMapGenerator.getDocument();
        GeneratedXmlFile gxf = new GeneratedXmlFile(document, this.getIbatis2SqlMapFileName(), this.getIbatis2SqlMapPackage(), this.ibatorContext.getSqlMapGeneratorConfiguration().getTargetProject(), true);
        if (this.ibatorContext.getPlugins().sqlMapGenerated(gxf, this)) {
            answer.add(gxf);
        }
        return answer;
    }

    @Override
    public boolean isJava5Targeted() {
        return false;
    }

    @Override
    public int getGenerationSteps() {
        return this.javaModelGenerators.size() + this.daoGenerators.size() + 1;
    }
}

