/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.dao.elements;

import java.util.Set;
import java.util.TreeSet;
import org.apache.ibatis.ibator.api.DAOMethodNameCalculator;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.Interface;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.PrimitiveTypeWrapper;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.AbstractDAOElementGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertMethodGenerator
extends AbstractDAOElementGenerator {
    @Override
    public void addImplementationElements(TopLevelClass topLevelClass) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        FullyQualifiedJavaType returnType = method.getReturnType();
        StringBuilder sb = new StringBuilder();
        if (returnType != null) {
            sb.append("Object newKey = ");
        }
        sb.append(this.daoTemplate.getInsertMethod(this.introspectedTable.getIbatis2SqlMapNamespace(), this.introspectedTable.getInsertStatementId(), "record"));
        method.addBodyLine(sb.toString());
        if (returnType != null) {
            if ("Object".equals(returnType.getShortName())) {
                method.addBodyLine("return newKey;");
            } else {
                sb.setLength(0);
                if (returnType.isPrimitive()) {
                    PrimitiveTypeWrapper ptw = returnType.getPrimitiveTypeWrapper();
                    sb.append("return ((");
                    sb.append(ptw.getShortName());
                    sb.append(") newKey");
                    sb.append(").");
                    sb.append(ptw.getToPrimitiveMethod());
                    sb.append(';');
                } else {
                    sb.append("return (");
                    sb.append(returnType.getShortName());
                    sb.append(") newKey;");
                }
                method.addBodyLine(sb.toString());
            }
        }
        if (this.ibatorContext.getPlugins().daoInsertMethodGenerated(method, topLevelClass, this.introspectedTable)) {
            topLevelClass.addImportedTypes(importedTypes);
            topLevelClass.addMethod(method);
        }
    }

    @Override
    public void addInterfaceElements(Interface interfaze) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        if (this.ibatorContext.getPlugins().daoInsertMethodGenerated(method, interfaze, this.introspectedTable)) {
            interfaze.addImportedTypes(importedTypes);
            interfaze.addMethod(method);
        }
    }

    private Method getMethodShell(Set<FullyQualifiedJavaType> importedTypes) {
        FullyQualifiedJavaType returnType;
        Method method = new Method();
        if (this.introspectedTable.getGeneratedKey() != null) {
            IntrospectedColumn introspectedColumn = this.introspectedTable.getColumn(this.introspectedTable.getGeneratedKey().getColumn());
            if (introspectedColumn == null) {
                returnType = null;
            } else {
                returnType = introspectedColumn.getFullyQualifiedJavaType();
                importedTypes.add(returnType);
            }
        } else {
            returnType = null;
        }
        method.setReturnType(returnType);
        method.setVisibility(JavaVisibility.PUBLIC);
        DAOMethodNameCalculator methodNameCalculator = this.getDAOMethodNameCalculator();
        method.setName(methodNameCalculator.getInsertMethodName(this.introspectedTable));
        FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
        importedTypes.add(parameterType);
        method.addParameter(new Parameter(parameterType, "record"));
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getCheckedExceptions()) {
            method.addException(fqjt);
            importedTypes.add(fqjt);
        }
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u63d2\u5165\uff0c\u6240\u6709\u5b57\u6bb5");
        return method;
    }
}

