/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class AppCodeVelocityEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(AppCodeVelocityEngine.class);
    private static final String DATADIR = "dataDir";
    private static final String JAVADIR = "javaDir";
    private static final String PACKAGE = "packAge";
    private static final String JAVATEMPLATE = "javaTemplate";
    private static final String SQLFILE = "sqlFile";
    private static final String SQLTEMPLATE = "sqlTemplate";

    public static void main(String[] args) throws Exception {
        List<CodeInfo> list = AppCodeVelocityEngine.findDesigner(AppCodeVelocityEngine.getDir(DATADIR));
        for (int i = 0; i < list.size(); ++i) {
            AppCodeVelocityEngine.javaGenerator(list.get(i));
        }
        AppCodeVelocityEngine.sqlGenerator(list);
    }

    public static void javaGenerator(CodeInfo codeinfo) {
        String javaTemplate = AppCodeVelocityEngine.getSysProperty(JAVATEMPLATE);
        File file = new File(javaTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + javaTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = AppCodeVelocityEngine.obj2Map(codeinfo);
            String packAge = AppCodeVelocityEngine.getSysProperty(PACKAGE);
            map.put(PACKAGE, packAge);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String javaDir = AppCodeVelocityEngine.getDir(JAVADIR);
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, javaTemplate), javaDir + packAge.replace(".", "/") + "/" + DesignerTools.capName(codeinfo.getCode()) + ".java");
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210\u679a\u4e3e\u7c7b\u9519\u8bef:", (Throwable)var7);
            }
        }
    }

    public static void sqlGenerator(List<CodeInfo> list) {
        String sqlTemplate = AppCodeVelocityEngine.getSysProperty(SQLTEMPLATE);
        File file = new File(sqlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + sqlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Map<?, ?> map = AppCodeVelocityEngine.obj2Map(list.get(i));
                mapList.add(map);
            }
            ctx.put("list", mapList);
            try {
                String sqlFile = AppCodeVelocityEngine.getSysProperty(SQLFILE);
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, sqlTemplate), sqlFile);
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210SQL\u9519\u8bef:", (Throwable)var7);
            }
        }
    }
}

