/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.util.List;
import java.util.Map;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cfg.Binder;
import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.NamedSQLQuery;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mappings {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$Mappings == null ? (class$net$sf$hibernate$cfg$Mappings = Mappings.class$("net.sf.hibernate.cfg.Mappings")) : class$net$sf$hibernate$cfg$Mappings));
    private final Map classes;
    private final Map collections;
    private final Map tables;
    private final Map queries;
    private final Map sqlqueries;
    private final List secondPasses;
    private final Map imports;
    private String schemaName;
    private String defaultCascade;
    private String defaultPackage;
    private String defaultAccess;
    private boolean autoImport;
    private final List propertyReferences;
    private final Map caches;
    private final NamingStrategy namingStrategy;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Mappings;

    Mappings(Map classes, Map collections, Map tables, Map queries, Map sqlqueries, Map imports, Map caches, List secondPasses, List propertyReferences, NamingStrategy namingStrategy) {
        this.classes = classes;
        this.collections = collections;
        this.queries = queries;
        this.sqlqueries = sqlqueries;
        this.tables = tables;
        this.imports = imports;
        this.secondPasses = secondPasses;
        this.propertyReferences = propertyReferences;
        this.caches = caches;
        this.namingStrategy = namingStrategy;
    }

    public void addClass(PersistentClass persistentClass) throws MappingException {
        PersistentClass old = this.classes.put(persistentClass.getMappedClass(), persistentClass);
        if (old != null) {
            log.warn((Object)("duplicate class mapping: " + persistentClass.getMappedClass().getName()));
        }
    }

    public void addCollection(Collection collection) throws MappingException {
        Collection old = this.collections.put(collection.getRole(), collection);
        if (old != null) {
            log.warn((Object)("duplicate collection role: " + collection.getRole()));
        }
    }

    public PersistentClass getClass(Class clazz) {
        return (PersistentClass)this.classes.get(clazz);
    }

    public Collection getCollection(String role) {
        return (Collection)this.collections.get(role);
    }

    public void addImport(String className, String rename) throws MappingException {
        if (this.imports.put(rename, className) != null) {
            throw new MappingException("duplicate import: " + rename);
        }
    }

    public Table addTable(String schema, String name) {
        String key = schema != null ? schema + "." + name : name;
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setName(name);
            table.setSchema(schema);
            this.tables.put(key, table);
        }
        return table;
    }

    public Table getTable(String schema, String name) {
        String key = schema != null ? schema + "." + name : name;
        return (Table)this.tables.get(key);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDefaultCascade(String defaultCascade) {
        this.defaultCascade = defaultCascade;
    }

    public void setDefaultAccess(String defaultAccess) {
        this.defaultAccess = defaultAccess;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public void addQuery(String name, String query) throws MappingException {
        this.checkQueryExist(name);
        this.queries.put(name, query);
    }

    public void addSQLQuery(String name, NamedSQLQuery query) throws MappingException {
        this.checkQueryExist(name);
        this.sqlqueries.put(name, query);
    }

    private void checkQueryExist(String name) throws MappingException {
        if (this.sqlqueries.containsKey(name) || this.queries.containsKey(name)) {
            throw new MappingException("Duplicate query named: " + name);
        }
    }

    public String getQuery(String name) {
        return (String)this.queries.get(name);
    }

    void addSecondPass(Binder.SecondPass sp) {
        this.secondPasses.add(sp);
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    void addUniquePropertyReference(Class referencedClass, String propertyName) {
        UniquePropertyReference upr = new UniquePropertyReference();
        upr.referencedClass = referencedClass;
        upr.propertyName = propertyName;
        this.propertyReferences.add(upr);
    }

    public void addCache(String name, CacheConcurrencyStrategy cache) throws MappingException {
        CacheConcurrencyStrategy old = this.caches.put(name, cache);
        if (old != null) {
            throw new MappingException("duplicate cache region");
        }
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class UniquePropertyReference {
        Class referencedClass;
        String propertyName;

        UniquePropertyReference() {
        }
    }
}

