/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.plugins;

import java.util.List;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.InnerClass;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.generator.ibatis2.Ibatis2FormattingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveLikePlugin
extends IbatorPluginAdapter {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass criteria = null;
        for (InnerClass innerClass : topLevelClass.getInnerClasses()) {
            if (!"Criteria".equals(innerClass.getType().getShortName())) continue;
            criteria = innerClass;
            break;
        }
        if (criteria == null) {
            return true;
        }
        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            if (!introspectedColumn.isJdbcCharacterColumn() || !introspectedColumn.isStringColumn()) continue;
            Method method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
            StringBuilder sb = new StringBuilder();
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            sb.insert(0, "and");
            sb.append("LikeInsensitive");
            method.setName(sb.toString());
            method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
            sb.setLength(0);
            sb.append("addCriterion(\"upper(");
            sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
            sb.append(") like\", value.toUpperCase(), \"");
            sb.append(introspectedColumn.getJavaProperty());
            sb.append("\");");
            method.addBodyLine(sb.toString());
            method.addBodyLine("return this;");
            criteria.addMethod(method);
        }
        return true;
    }
}

